<?php
date_default_timezone_set('Asia/Jakarta'); // Set zona waktu

// Menampilkan debugging data POST
echo "Debugging Data POST:<br>";
print_r($_POST); // Menampilkan semua data POST yang diterima

include('koneksi.php'); // Menyambungkan ke database

// Ambil parameter dari POST
$suhu = isset($_POST['suhu']) ? (float)$_POST['suhu'] : null;
$kelembaban = isset($_POST['kelembaban']) ? (float)$_POST['kelembaban'] : null;
$co = isset($_POST['co']) ? (float)$_POST['co'] : null;
$co2 = isset($_POST['co2']) ? (float)$_POST['co2'] : null;
$intensitas_cahaya = isset($_POST['intensitas_cahaya']) ? (float)$_POST['intensitas_cahaya'] : null;
$rain_sensor = isset($_POST['rain_sensor']) ? $_POST['rain_sensor'] : null; // Parameter status ("Hujan" atau "Terang")

// Debugging data yang diterima
echo "Data yang diterima:<br>";
echo "Suhu: $suhu<br>";
echo "Kelembaban: $kelembaban<br>";
echo "CO: $co<br>";
echo "CO2: $co2<br>";
echo "Intensitas Cahaya: $intensitas_cahaya<br>";
echo "Rain Sensor Status: $rain_sensor<br>";

// Periksa parameter wajib
if ($suhu === null || $kelembaban === null || $co === null || $co2 === null || $intensitas_cahaya === null || $rain_sensor === null) {
    echo "Error: Semua parameter harus diisi.<br>";
    exit;
}

// Set kualitas udara berdasarkan nilai CO dan CO2
$kualitas_udara = ($co <= 10 && $co2 <= 1000) ? "Aman" : "Berbahaya";

// Waktu saat ini
$waktu = date('Y-m-d H:i:s');

// Simpan data ke database
$sql = "INSERT INTO monitoring_data (suhu, kelembaban, co, co2, intensitas_cahaya, kondisi_lingkungan, kualitas_udara, waktu) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
$stmt = $conn->prepare($sql);

if ($stmt === false) {
    die("Error preparing statement: " . $conn->error);
}

// Binding parameter ke query SQL
$stmt->bind_param("ddddssss", $suhu, $kelembaban, $co, $co2, $intensitas_cahaya, $rain_sensor, $kualitas_udara, $waktu);

// Eksekusi query dan periksa hasilnya
if ($stmt->execute()) {
    echo "Data berhasil disimpan ke database.";
} else {
    echo "Error: " . $stmt->error;
}

// Tutup statement dan koneksi
$stmt->close();
$conn->close();
?>
