<?php
include('koneksi.php');

// Ambil data terbaru
$query = "SELECT * FROM monitoring_data ORDER BY waktu DESC LIMIT 1";
$result = $conn->query($query);

if ($result->num_rows > 0) {
    $data = $result->fetch_assoc();
} else {
    $data = null; // Menangani jika tidak ada data
}

// Ambil data lima hari terakhir
$query_terbaru = "
  SELECT tanggal, 
         FLOOR(suhu) AS suhu,  
         FLOOR(kelembaban) AS kelembaban  
  FROM (
    SELECT DATE(waktu) AS tanggal, 
           suhu, 
           kelembaban, 
           ROW_NUMBER() OVER (
               PARTITION BY DATE(waktu) 
               ORDER BY COUNT(*) DESC, suhu DESC, kelembaban DESC
           ) AS ranking
    FROM monitoring_data
    WHERE DATE(waktu) < CURDATE() AND DATE(waktu) >= CURDATE() - INTERVAL 5 DAY
    GROUP BY DATE(waktu), suhu, kelembaban
  ) AS ranked
  WHERE ranking = 1
  ORDER BY tanggal DESC";

$result_terbaru = $conn->query($query_terbaru);

$data_terbaru = [];
if ($result_terbaru->num_rows > 0) {
    while ($row = $result_terbaru->fetch_assoc()) {
        $data_terbaru[] = $row;
    }
}

// Menangani nilai NULL
if ($data) {
    $data['intensitas_cahaya'] = $data['intensitas_cahaya'] ?? 'Tidak Tersedia';
    $data['kondisi_lingkungan'] = $data['kondisi_lingkungan'] ?? 'Tidak Tersedia';
}

// Menambahkan header CORS
header("Access-Control-Allow-Origin: *"); // Mengizinkan semua domain. Anda bisa menggantinya dengan 'http://192.168.18.8' jika hanya ingin mengizinkan domain tersebut.
header("Access-Control-Allow-Methods: GET, POST, OPTIONS"); // Mengizinkan metode GET, POST, dan OPTIONS
header("Access-Control-Allow-Headers: Content-Type"); // Mengizinkan header Content-Type

// Jika request menggunakan OPTIONS, langsung berikan response tanpa melanjutkan ke proses lainnya
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

$response = [
    'data' => $data,
    'data_terbaru' => $data_terbaru
];

// Kirim respons dalam format JSON
header('Content-Type: application/json');
echo json_encode($response);

$conn->close();
?>
